#==============================================================================
#  Window_Battle_AI_Menu
#------------------------------------------------------------------------------
# 퓬`hIEBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  class Window_Battle_AI_Menu < ::DQ::Window_Page_Menu
    include Window_Tree_Module
    #----------------------------------------------------------------------------
    # 
    #----------------------------------------------------------------------------
    def initialize(parent)
      @title = '˂'
      @title_align = 1
      @index = 0
      @parent = parent

      create_menu()
      super(parent)

      # ʒu̐ݒ
      self.top = parent.bottom
      self.left = parent.left
    end

    def ai_disable?(name)
      result = true
      self.actors.each do |actor|
        if not actor.ai_fix?
          result = (result and actor.ai_disable_names.include?(name))
        end
      end
      return result
    end

    def create_menu
      names = Battle_AI_Manager.names
      names.each do |name|
        if not ai_disable?(name)
          add_menu(name,:select_operation)
        end
      end
      if not ai_disable?(DEFAULT_OPERATION_NAME)
        add_menu(DEFAULT_OPERATION_NAME,:select_no_operation)
      end
    end

    def actors
      if parent.actor.nil?
        return $game_party.actors
      end
      return [parent.actor]
    end

    def select_operation
      self.actors.each do |actor|
        if not actor.ai_fix?
          actor.ai = Battle_AI_Manager.operation(get_menu)
        end
      end
      parent.refresh
      dispose
    end

    def select_no_operation
      self.actors.each do |actor|
        if not actor.ai_fix?
          actor.ai = nil
        end
      end
      parent.refresh
      dispose
    end

  end

end
